classdef hard_cubic
    %HARD_CUBIC Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        L;
        mu;
        gamma;
        f; % function
        g; % gradient
        H; % Hessian
    end
    
    methods
        function obj = hard_cubic(L,mu,gamma)
            %HARD_CUBIC Construct an instance of this class
            %   Detailed explanation goes here
            if nargin > 0
                obj.L = L;
                obj.mu = mu;
                obj.gamma = gamma;
                if mu>0 % strongly convex case TODO
                    obj.f = @(x) L/36*(sum(abs(diff(x)).^3) - 3*gamma*x(1)) + mu/2*norm(x)^2;
                    obj.g = @(x) -L/12*diff([0;abs(diff(x)).^2.*sign(diff(x));0])- L/36*[3*gamma; zeros(length(x)-1,1)] + mu*x;
                    obj.H = @(x) L/6*(diag([abs(diff(x));0])+...
                            diag([0;abs(diff(x))])-...
                            diag(abs(diff(x)),1)-...
                            diag(abs(diff(x)),-1))+mu*eye(length(x));
                else % convex case
                    obj.f = @(x) L/3*(sum(abs(diff([x;0])).^3) - 3*gamma*x(1));
                    obj.g = @(x) -L*diff([0;abs(diff([x;0])).^2.*sign(diff([x;0]))])- L*[gamma; zeros(length(x)-1,1)];
                    obj.H = @(x) 2*L*(diag(abs(diff([x;0])))+...
                            diag(abs(diff([x(1);x])))-...
                            diag(abs(diff(x)),1)-...
                            diag(abs(diff(x)),-1)) ;
                end
            end
        end
    end
end

